package com.ejie.ab04b.control;

import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.VestadisticaFormaPre;
import com.ejie.ab04b.model.Vlistestprev;
import com.ejie.ab04b.service.ComunicacionAperturaService;
import com.ejie.ab04b.service.VestadisticaFormaPreService;
import com.ejie.ab04b.service.VlistestprevService;
import com.ejie.ab04b.service.pif.PifService;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ab04b.validation.AbstractValidator.Oper;
import com.ejie.ab04b.validation.ComunicacionAperturaValidator;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * ListadosController generated by UDA, 26-dic-2016 13:08:27.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/listados")
public class ListadosController {

	private static final String ATTR_NAME_COMUNICAPERTURA_FILTER = "comunicAperturasFiltroModel";
	private static final String ATTR_NAME_LISTADOCOMUNICAPERTURA_FILTER = "listadoComunicAperturasFiltroModel";
	private static final String ATTR_NAME_VESTADISTICAFORMAPRE_FILTER = "vestadisticaFormaPreModel";
	private static final String ATTR_NAME_LISTADOESTADISTICASPREVENCION_FILTER = "listadoEstadisticasPrevencionModel";

	@Autowired()
	private PifService pifService;

	@Autowired()
	private ComunicacionAperturaValidator comunicacionAperturaValidator;

	@Autowired()
	private ComunicacionAperturaService comunicAperturaService;

	@Autowired()
	private VestadisticaFormaPreService vestadisticaFormaPreService;

	@Autowired()
	private VlistestprevService vlistestprevService;

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado comunicacion aperturas
	 */
	@RequestMapping(value = "/listadoComunicacionAperturas", method = RequestMethod.GET)
	public String getListadoComunicacionAperturas(Model model, Locale locale) {
		// Combos del Filtro
		this.precargaCombosFiltroBusquedaAperturas(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(
				ListadosController.ATTR_NAME_LISTADOCOMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoComunicacionAperturas";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoComunicacionAperturas/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoComunicacionAperturas(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		return this.comunicAperturaService.filterListadoAperturas(filtro,
				jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado comunicacion aperturas PDF
	 * @return the listado comunicacion aperturas PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoComunicacionAperturasPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoComunicacionAperturasPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {

		try {
			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService
					.filterListadoComunicacionAperturasPDF(filtro,
							jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_COM_APE_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado comunicacion aperturas num
	 */
	@RequestMapping(value = "/listadoComunicacionAperturasNum", method = RequestMethod.GET)
	public String getListadoComunicacionAperturasNum(Model model, Locale locale) {
		// Combos del Filtro
		this.precargaCombosFiltroBusquedaAperturas(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(
				ListadosController.ATTR_NAME_LISTADOCOMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoComunicacionAperturas";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoComunicacionAperturasNum/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoComunicacionAperturasNum(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		return this.comunicAperturaService.filterListadoAperturasNum(filtro,
				jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado comunicacion aperturas num PDF
	 * @return the listado comunicacion aperturas num PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoComunicacionAperturasNumPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoComunicacionAperturasNumPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {
			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService
					.filterListadoComunicacionAperturasNumPDF(filtro,
							jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_COM_APE_NUM_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado sin info osalan
	 */
	@RequestMapping(value = "/listadoSinInfoOsalan", method = RequestMethod.GET)
	public String getListadoSinInfoOsalan(Model model, Locale locale) {
		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(ListadosController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoSinInfoOsalan";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoSinInfoOsalan/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoSinInfoOsalan(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		return this.comunicAperturaService.filterListadoSinInfoOsalan(filtro,
				jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado sin info osalan PDF
	 * @return the listado sin info osalan PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoSinInfoOsalanPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoSinInfoOsalanPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {
			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService
					.filterListadoSinInfoOsalanPDF(filtro, jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_SIN_INF_OS_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado anual mes ter
	 */
	@RequestMapping(value = "/listadoAnualMesTer", method = RequestMethod.GET)
	public String getListadoAnualMesTer(Model model, Locale locale) {
		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(ListadosController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoAnualMesTer";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoAnualMesTer/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoAnualMesTer(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		// Validate
		List<ErrorField> errores = this.comunicacionAperturaValidator.validate(
				filtro, Oper.FILTER_LIST_ANUAL_MES_TER);
		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		return this.comunicAperturaService.filterListadoAnualMesTer(filtro,
				jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado anual mes ter PDF
	 * @return the listado anual mes ter PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoAnualMesTerPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoAnualMesTerPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {

			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService.filterListadoAnualMesTerPDF(
					filtro, jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_ANU_MES_TER_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado anual sec ter
	 */
	@RequestMapping(value = "/listadoAnualSecTer", method = RequestMethod.GET)
	public String getListadoAnualSecTer(Model model, Locale locale) {
		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(ListadosController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoAnualSecTer";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoAnualSecTer/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoAnualSecTer(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {
		// Validate
		List<ErrorField> errores = this.comunicacionAperturaValidator.validate(
				filtro, Oper.FILTER_LIST_ANUAL_SEC_TER);
		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		return this.comunicAperturaService.filterListadoAnualSecTer(filtro,
				jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado anual sec ter PDF
	 * @return the listado anual sec ter PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoAnualSecTerPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoAnualSecTerPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {
			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService.filterListadoAnualSecTerPDF(
					filtro, jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_ANU_SEC_TER_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado bianual mes ter
	 */
	@RequestMapping(value = "/listadoBianualMesTer", method = RequestMethod.GET)
	public String getListadoBianualMesTer(Model model, Locale locale) {
		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(ListadosController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoBianualMesTer";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoBianualMesTer/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoBianualMesTer(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		// Validate
		List<ErrorField> errores = this.comunicacionAperturaValidator.validate(
				filtro, Oper.FILTER_LIST_ANUAL_MES_TER);
		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		return this.comunicAperturaService.filterListadoBianualMesTer(filtro,
				jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado bianual mes ter PDF
	 * @return the listado bianual mes ter PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoBianualMesTerPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoBianualMesTerPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {
			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService
					.filterListadoBianualMesTerPDF(filtro, jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_BIANU_MES_TER_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado tramos trabajadores
	 */
	@RequestMapping(value = "/listadoTramosTrabajadores", method = RequestMethod.GET)
	public String getListadoTramosTrabajadores(Model model, Locale locale) {

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(ListadosController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoTramosTrabajadores";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoTramosTrabajadores/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoTramosTrabajadores(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		return this.comunicAperturaService.filterListadoTramosTrabajadores(
				filtro, jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado tramos trabajadores PDF
	 * @return the listado tramos trabajadores PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoTramosTrabajadoresPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoTramosTrabajadoresPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {

		try {
			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService
					.filterListadoTramosTrabajadoresPDF(filtro,
							jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_TRAM_TRAB_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado tramos trabajadores por centro
	 */
	@RequestMapping(value = "/listadoTramosTrabajadoresPorCentro", method = RequestMethod.GET)
	public String getListadoTramosTrabajadoresPorCentro(Model model,
			Locale locale) {

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(ListadosController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoTramosTrabajadores";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoTramosTrabajadoresPorCentro/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoTramosTrabajadoresPorCentro(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		return this.comunicAperturaService
				.filterlistadoTramosTrabajadoresPorCentro(filtro,
						jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado tramos trabajadores por centro PDF
	 * @return the listado tramos trabajadores por centro PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoTramosTrabajadoresPorCentroPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoTramosTrabajadoresPorCentroPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {

			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService
					.filterListadoTramosTrabajadoresPorCentroPDF(filtro,
							jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_TRAM_TRAB_CEN_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado tramos trabajadores por trab
	 */
	@RequestMapping(value = "/listadoTramosTrabajadoresPorTrab", method = RequestMethod.GET)
	public String getListadoTramosTrabajadoresPorTrab(Model model, Locale locale) {

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(ListadosController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoTramosTrabajadores";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoTramosTrabajadoresPorTrab/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoTramosTrabajadoresPorTrab(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		return this.comunicAperturaService
				.filterListadoTramosTrabajadoresPorTrab(filtro,
						jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado tramos trabajadores por trab PDF
	 * @return the listado tramos trabajadores por trab PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoTramosTrabajadoresPorTrabPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoTramosTrabajadoresPorTrabPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {

		try {
			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService
					.filterListadoTramosTrabajadoresPorTrabPDF(filtro,
							jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_TRAM_TRAB_TRAB_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado subsanacion
	 */
	@RequestMapping(value = "/listadoSubsanacion", method = RequestMethod.GET)
	public String getListadoSubsanacion(Model model, Locale locale) {

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
		Calendar c = Calendar.getInstance();
		comunicacionApertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(ListadosController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				comunicacionApertura);

		return "listadoSubsanacion";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/listadoSubsanacion/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<ComunicacionApertura> filterListadoSubsanacion(
			@RequestJsonBody(param = "filter") ComunicacionApertura filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		return this.comunicAperturaService.filterListadoSubsanacion(filtro,
				jqGridRequestDto, false);
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the listado subsanacion PDF
	 * @return the listado subsanacion PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "listadoSubsanacionPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getListadoSubsanacionPDF(
			@ModelAttribute() ComunicacionApertura filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {

			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.comunicAperturaService.filterListadoSubsanacionPDF(
					filtro, jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_SUB_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the vestadistica forma pre
	 */
	@RequestMapping(value = "/vestadisticaFormaPre", method = RequestMethod.GET)
	public String getVestadisticaFormaPre(Model model, Locale locale) {

		VestadisticaFormaPre listado = new VestadisticaFormaPre();
		Calendar c = Calendar.getInstance();
		listado.setAnio(String.valueOf(c.get(Calendar.YEAR)));
		listado.setAgrupacion("anios");
		this.precargaCombosFiltroBusqueda(model);
		model.addAttribute(
				ListadosController.ATTR_NAME_VESTADISTICAFORMAPRE_FILTER,
				listado);

		return "vestadisticaformapre";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = "/vestadisticaFormaPre/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<VestadisticaFormaPre> filterVestadisticaFormaPre(
			@RequestJsonBody(param = "filter") VestadisticaFormaPre filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {
			if (null == filtro.getAgrupacion()
					|| filtro.getAgrupacion().equals("")) {
				filtro.setAgrupacion("anios");
			}

			return this.vestadisticaFormaPreService.filter(filtro,
					jqGridRequestDto, false);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the vestadistica forma pre PDF
	 * @return the vestadistica forma pre PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "VestadisticaFormaPrePDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getVestadisticaFormaPrePDF(
			@ModelAttribute() VestadisticaFormaPre filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {

			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.vestadisticaFormaPreService
					.filterVestadisticaFormaPrePDF(filtro, jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_EST_FORM_PRE_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();

		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale String
	 * @return the listado estadisticas prevencion
	 */
	@RequestMapping(value = "/listadoEstadisticasPrevencion", method = RequestMethod.GET)
	public String getListadoEstadisticasPrevencion(Model model, Locale locale) {

		Vlistestprev listado = new Vlistestprev();
		Calendar c = Calendar.getInstance();
		listado.setAnio(String.valueOf(c.get(Calendar.YEAR)));
		this.precargaCombosFiltroBusqueda(model);
		model.addAttribute(
				ListadosController.ATTR_NAME_LISTADOESTADISTICASPREVENCION_FILTER,
				listado);

		return "listadoestadisticasprevencion";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filtro ComunicacionApertura Bean que contiene los parametros de filtrado
	 * a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = "/listadoEstadisticasPrevencion/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<Vlistestprev> filterListadoEstadisticasPrevencion(
			@RequestJsonBody(param = "filter") Vlistestprev filtro,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {

			return this.vlistestprevService.filter(filtro, jqGridRequestDto,
					false);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * filtro Expediente Bean que contiene los parÃ¡metros de filtrado a
	 * emplear. jqGridRequestDto JQGridRequestDto que contiene los parÃ¡mtros de
	 * configuraciÃ³n propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest response HttpServletResponse
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request
	 * @param response
	 *            the response the vlistestprev PDF
	 * @return the vlistestprev PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = { "VlistestprevPDF" }, method = RequestMethod.POST)
	public @ResponseBody
	void getVlistestprevPDF(@ModelAttribute() Vlistestprev filtro,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {

			// Limpiamos los datos de paginacion para mostrar todos los
			// registros
			jqGridRequestDto.setPage(null);
			jqGridRequestDto.setRows(null);

			String informe = "";
			informe = this.vlistestprevService.filterVlistestprevPDF(filtro,
					jqGridRequestDto);

			InputStream is = pifService.downloadDocument(informe);
			byte[] bytes = IOUtils.toByteArray(is);

			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(ConstantesNum.NUM_2);
			cookie.setPath("/");
			response.addCookie(cookie);

			String headerKey = "Content-Disposition";
			String headerValue = String.format("attachment; filename=\"%s\"",
					Constantes.LIS_EST_PREV_PDF);
			response.setHeader(headerKey, headerValue);
			response.setContentType("application/force-download");

			response.getOutputStream().write(bytes);
			response.flushBuffer();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * AÃ±ade al model los datos necesarios para la carga de los combos de la
	 * pantalla del filtro de busqueda.
	 * 
	 * model Model
	 * 
	 * @param model
	 *            the model
	 */
	private void precargaCombosFiltroBusqueda(Model model) {

		model.addAttribute("autoridades", UtilSeguridad.getInstance()
				.obtenerDelegacionesUsuario());

		// Ind. obra
		model.addAttribute("obra", Constantes.COMBO_SI_NO);
	}

	/**
	 * AÃ±ade al model los datos necesarios para la carga de los combos de la
	 * pantalla del filtro de busqueda.
	 * 
	 * model Model
	 * 
	 * @param model
	 *            the model
	 */
	private void precargaCombosFiltroBusquedaAperturas(Model model) {

		model.addAttribute("autoridades", UtilSeguridad.getInstance()
				.obtenerDelegacionesUsuario());

		// Ind. obra
		model.addAttribute("obra", Constantes.COMBO_SI_NO);

		// tipo identificacion
		model.addAttribute("tipoidentificacion", Constantes.COMBO_TIPO_IDENTIF);

		// Indicador informe osalan
		model.addAttribute("indInformeOsalan", Constantes.COMBO_SI_NO);

		// Indicador informe inspeccion
		model.addAttribute("indInformeInspeccion", Constantes.COMBO_SI_NO);

		// Tareas Pendientes
		model.addAttribute("tareasPendientes",
				Constantes.COMBO_TAREAS_PENDIENTE);

		// Indicador de envio de notificacion
		model.addAttribute("indEnvio", Constantes.COMBO_TODAS_PENDIENTES);
	}
}
